/*
 * Decompiled with CFR 0.152.
 */
package dev.toma.gunsrpg.common.item.guns.util;

import dev.toma.gunsrpg.api.common.data.IPlayerData;
import dev.toma.gunsrpg.common.item.guns.GunItem;
import dev.toma.gunsrpg.common.item.guns.setup.AbstractGun;
import dev.toma.gunsrpg.common.item.guns.util.InputEventListenerType;
import dev.toma.gunsrpg.util.object.ShootingManager;
import java.util.function.BooleanSupplier;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;

@FunctionalInterface
public interface IInputEventHandler {
    public void invokeEvent(InputEventListenerType var1, PlayerEntity var2, ItemStack var3, IPlayerData var4);

    public static class Utils {
        static boolean isWeaponInShootableState(ItemStack stack) {
            return stack.func_77952_i() < stack.func_77958_k() && !((GunItem)stack.func_77973_b()).isJammed(stack);
        }

        static void shootWithValidation(PlayerEntity player, ItemStack stack, IPlayerData data) {
            if (ShootingManager.canShoot(player, stack)) {
                ShootingManager.Client.shoot(player, stack, data);
            }
        }
    }

    public static class Barrage
    implements IInputEventHandler {
        @Override
        public void invokeEvent(InputEventListenerType event, PlayerEntity player, ItemStack stack, IPlayerData data) {
            if (ShootingManager.canShoot(player, stack)) {
                ShootingManager.Client.shoot(player, stack, data);
                ShootingManager.Client.forceShootDelay(3);
            }
        }
    }

    public static class Double
    implements IInputEventHandler {
        @Override
        public void invokeEvent(InputEventListenerType event, PlayerEntity player, ItemStack stack, IPlayerData data) {
            int ammo = AbstractGun.getAmmoCount(stack);
            boolean canShootSecond = ammo > 1;
            Utils.shootWithValidation(player, stack, data);
            if (canShootSecond && Utils.isWeaponInShootableState(stack)) {
                ShootingManager.Client.shoot(player, stack, data);
            }
        }
    }

    public static class FullAuto
    implements IInputEventHandler {
        @Override
        public void invokeEvent(InputEventListenerType event, PlayerEntity player, ItemStack stack, IPlayerData data) {
            Utils.shootWithValidation(player, stack, data);
        }
    }

    public static class Burst
    implements IInputEventHandler {
        private final BooleanSupplier shootReady = ShootingManager::isShootingReady;
        private int shotsLeft;
        private Item heldItem;

        @Override
        public void invokeEvent(InputEventListenerType event, PlayerEntity player, ItemStack stack, IPlayerData data) {
            switch (event) {
                case ON_INPUT: {
                    this.handleInput(stack);
                    break;
                }
                case ON_BURST_TICK: {
                    this.handleTick(player, stack, data);
                }
            }
        }

        private void handleInput(ItemStack stack) {
            if (!ShootingManager.Client.isBurstModeActive()) {
                ShootingManager.Client.setBurstActive(true);
                this.shotsLeft = 3;
                this.heldItem = stack.func_77973_b();
            }
        }

        private void handleTick(PlayerEntity player, ItemStack stack, IPlayerData data) {
            if (this.shootReady.getAsBoolean()) {
                if (this.heldItem == stack.func_77973_b() && ShootingManager.canShoot(player, stack)) {
                    ShootingManager.Client.shoot(player, stack, data);
                    if (--this.shotsLeft <= 0) {
                        ShootingManager.Client.setBurstActive(false);
                    }
                } else {
                    ShootingManager.Client.setBurstActive(false);
                }
            }
        }
    }

    public static class Single
    implements IInputEventHandler {
        @Override
        public void invokeEvent(InputEventListenerType event, PlayerEntity player, ItemStack stack, IPlayerData data) {
            Utils.shootWithValidation(player, stack, data);
        }
    }
}

